/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.DNSAndIPAddrListBoxesInterface;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.certs.SubjectAltNames;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;

class CertMgtPanelUtils
implements CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTMPUD";
    private static final String TRACE_MASKF = "XCRTMPUF";
    private static final String TRACE_MASKT = "XCRTMPUT";

    private CertMgtPanelUtils() {
    }

    public static void main(String[] args) {
    }

    static void sendTaskletRequest(String actionCommand, Serializable data, Serializable data2, ServerCert certificate, PanelBean bean) {
        PanelTaskletRequest request = null;
        Trace.trace(TRACE_MASKT, "<->sendTaskletRequest(" + actionCommand + ", " + data + ", " + data2 + ", " + certificate + ", " + bean + ")");
        request = new PanelTaskletRequest(bean.getBeanName() + '.' + actionCommand);
        request.setData("Source", bean.getBeanName());
        request.setData("Action", actionCommand);
        request.setData("Data", data);
        request.setData("Data2", data2);
        request.setData("Cert", certificate);
        bean.postTaskletRequest(request);
    }

    static void sendTaskletRequest(String actionCommand, Serializable data, PanelBean bean) {
        CertMgtPanelUtils.sendTaskletRequest(actionCommand, data, null, null, bean);
    }

    static void sendCancelRequest(PanelBean bean) {
        PanelTaskletRequest request = null;
        Trace.trace(TRACE_MASKT, "<->sendCancelRequest(" + bean + ")");
        request = new PanelTaskletRequest(bean.getBeanName());
        request.setCanceled();
        bean.postTaskletRequest(request);
    }

    static void createItemDescriptor(ItemDescriptor[][] table, int i, String property, String value) {
        ItemDescriptor[] row = null;
        Trace.trace(TRACE_MASKT, "<->createItemDescriptor(" + table + ", " + i + ", " + property + ", " + value + ")");
        row = new ItemDescriptor[]{new ItemDescriptor(i + ".ServerCertTable.Name", property), new ItemDescriptor(i + ".ServerCertTable.Value", value)};
        table[i] = row;
    }

    static void handleDNSAndIPAddrListBoxes(String actionCommand, String elementName, UserTaskManager utm, DNSAndIPAddrListBoxesInterface bean, String mountPrefix, ServerCert inCertificate) {
        ValueDescriptor[] newListBox = null;
        String newEntry = null;
        if (actionCommand.equals("AddDNSButton")) {
            newListBox = CertMgtPanelUtils.handleAdd(utm, bean.getDNSEntry(), bean.getDNSListBoxList(), "DNSListBox");
            if (newListBox != null) {
                bean.setDNSListBoxList(newListBox);
                if (utm != null) {
                    Trace.trace(TRACE_MASKD, "refreshing the list box using a mount prefix of " + mountPrefix);
                    utm.refreshElement(mountPrefix + "DNSListBox");
                }
            }
            Trace.trace(TRACE_MASKD, "clearing out the DNS entry field");
            bean.setDNSEntryWithoutChecks(null);
            if (utm != null) {
                Trace.trace(TRACE_MASKD, "refreshing the DNS entry field using a mount prefix of " + mountPrefix);
                utm.refreshElement(mountPrefix + "DNSEntry");
            }
        } else if (actionCommand.equals("AddIPAddrButton")) {
            String networkByte0 = bean.getIPAddrNetworkByte0();
            String networkByte1 = bean.getIPAddrNetworkByte1();
            String networkByte2 = bean.getIPAddrNetworkByte2();
            String networkByte3 = bean.getIPAddrNetworkByte3();
            newEntry = networkByte0 == null || networkByte1 == null || networkByte2 == null || networkByte3 == null ? null : networkByte0 + "." + networkByte1 + "." + networkByte2 + "." + networkByte3;
            newListBox = CertMgtPanelUtils.handleAdd(utm, newEntry, bean.getIPAddrListBoxList(), "IPAddrListBox");
            if (newListBox != null) {
                bean.setIPAddrListBoxList(newListBox);
                if (utm != null) {
                    Trace.trace(TRACE_MASKD, "refreshing the list box using a mount prefix of " + mountPrefix);
                    utm.refreshElement(mountPrefix + "IPAddrListBox");
                }
            }
            Trace.trace(TRACE_MASKD, "clearing out the IP address entry fields");
            bean.setIPAddrNetworkByte0WithoutChecks(null);
            bean.setIPAddrNetworkByte1WithoutChecks(null);
            bean.setIPAddrNetworkByte2WithoutChecks(null);
            bean.setIPAddrNetworkByte3WithoutChecks(null);
            if (utm != null) {
                Trace.trace(TRACE_MASKD, "refreshing the IP address entry fields using a mount prefix of " + mountPrefix);
                utm.refreshElement(mountPrefix + "IPAddrNetworkByte0");
                utm.refreshElement(mountPrefix + "IPAddrNetworkByte1");
                utm.refreshElement(mountPrefix + "IPAddrNetworkByte2");
                utm.refreshElement(mountPrefix + "IPAddrNetworkByte3");
            }
        } else if (actionCommand.equals("RemoveDNSButton")) {
            newListBox = CertMgtPanelUtils.handleDelete(utm, bean.getDNSListBox(), bean.getDNSListBoxList());
            if (newListBox != null) {
                bean.setDNSListBoxList(newListBox);
                if (utm != null) {
                    Trace.trace(TRACE_MASKD, "refreshing the list box using a mount prefix of " + mountPrefix);
                    utm.refreshElement(mountPrefix + "DNSListBox");
                }
            }
        } else if (actionCommand.equals("RemoveIPAddrButton")) {
            newListBox = CertMgtPanelUtils.handleDelete(utm, bean.getIPAddrListBox(), bean.getIPAddrListBoxList());
            if (newListBox != null) {
                bean.setIPAddrListBoxList(newListBox);
                if (utm != null) {
                    Trace.trace(TRACE_MASKD, "refreshing the list box using a mount prefix of " + mountPrefix);
                    utm.refreshElement(mountPrefix + "IPAddrListBox");
                }
            }
        } else if (elementName.equals("SubjectAltNamesOKButton")) {
            CertMgtPanelUtils.sendTaskletRequest("finishModSubjectAltNames", CertMgtPanelUtils.getSubjectAltNames(bean.getDNSListBoxList(), bean.getIPAddrListBoxList()), null, inCertificate, bean.getPanelBean());
        } else {
            Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
            new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
        }
    }

    private static ValueDescriptor[] handleAdd(UserTaskManager utm, String entryToAdd, ValueDescriptor[] listBox, String name) {
        block9: {
            block8: {
                int currentListBoxLen = 0;
                ValueDescriptor[] newListBox = null;
                if (utm != null) {
                    Trace.trace(TRACE_MASKD, "storing all elements");
                    utm.storeAllElements();
                }
                if (entryToAdd == null) break block8;
                Trace.trace(TRACE_MASKD, "entryToAdd set to " + entryToAdd);
                if (entryToAdd.length() > 0) {
                    currentListBoxLen = 0;
                    if (listBox != null) {
                        currentListBoxLen = listBox.length;
                    }
                    Trace.trace(TRACE_MASKD, "currentListBoxLen set to " + currentListBoxLen);
                    newListBox = new ValueDescriptor[currentListBoxLen + 1];
                    if (currentListBoxLen > 0) {
                        System.arraycopy(listBox, 0, newListBox, 0, currentListBoxLen);
                    }
                    newListBox[currentListBoxLen] = CertMgtPanelUtils.createValueDescriptor(name, entryToAdd);
                    return newListBox;
                }
                if (utm == null) break block9;
                try {
                    CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0008"), MsgType.ERROR_MESSAGE);
                }
                catch (HException e) {
                    new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                }
                break block9;
            }
            if (utm == null) break block9;
            try {
                CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0008"), MsgType.ERROR_MESSAGE);
            }
            catch (HException e) {
                new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
            }
        }
        return null;
    }

    private static ValueDescriptor[] handleDelete(UserTaskManager utm, String selectedLine, ValueDescriptor[] listBox) {
        int newListBoxLength = 0;
        ValueDescriptor[] newListBox = null;
        boolean deletedLine = false;
        Trace.trace(TRACE_MASKT, "->handleDelete(" + utm + ", " + selectedLine + ", " + listBox + ")");
        if (utm != null) {
            utm.storeAllElements();
        }
        if (selectedLine != null) {
            if (listBox != null) {
                newListBoxLength = listBox.length - 1;
                if (newListBoxLength >= 0) {
                    newListBox = new ValueDescriptor[newListBoxLength];
                }
                deletedLine = false;
                int i = 0;
                int j = 0;
                while (i < listBox.length) {
                    if (!listBox[i].getTitle().equals(selectedLine)) {
                        if (j < newListBoxLength) {
                            Trace.trace(TRACE_MASKD, "copying element with a title of " + listBox[i].getTitle());
                            newListBox[j++] = listBox[i];
                        }
                    } else {
                        Trace.trace(TRACE_MASKD, "deleting element at index " + i);
                        deletedLine = true;
                    }
                    ++i;
                }
                if (deletedLine) {
                    Trace.trace(TRACE_MASKT, "<-handleDelete(...) returning : " + newListBox);
                    return newListBox;
                }
            }
        } else if (utm != null) {
            try {
                CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0012"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0013"), MsgType.ERROR_MESSAGE);
            }
            catch (HException e) {
                new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-handleDelete(...) returning null");
        return null;
    }

    static ValueDescriptor createValueDescriptor(String listBoxName, String value) {
        Trace.trace(TRACE_MASKT, "<->createValueDescriptor(" + listBoxName + ", " + value + ")");
        return new ValueDescriptor("Name." + listBoxName + "." + value, value);
    }

    static SubjectAltNames getSubjectAltNames(ValueDescriptor[] dnsListBox, ValueDescriptor[] ipAddrListBox) {
        int i;
        SubjectAltNames result = null;
        result = new SubjectAltNames();
        if (dnsListBox != null) {
            i = 0;
            while (i < dnsListBox.length) {
                result.addDNSName(dnsListBox[i].getTitle());
                ++i;
            }
        }
        if (ipAddrListBox != null) {
            i = 0;
            while (i < ipAddrListBox.length) {
                result.addIPAddrName(ipAddrListBox[i].getTitle());
                ++i;
            }
        }
        return result;
    }

    static ItemDescriptor[][] createCertTable(ServerCert certificate) {
        ItemDescriptor[][] result = null;
        int version = 0;
        BigInteger serialNumber = null;
        CertPrincipal issuer = null;
        CertPrincipal subject = null;
        SubjectAltNames subjectAltNames = null;
        Date notBeforeDate = null;
        Date notAfterDate = null;
        Integer days = null;
        if (certificate != null) {
            result = new ItemDescriptor[7][2];
            version = certificate.getVersion();
            serialNumber = certificate.getSerialNumber();
            issuer = certificate.getIssuerX500Principal();
            subject = certificate.getSubject();
            subjectAltNames = certificate.getSubjectAltNames();
            notBeforeDate = certificate.getNotBefore();
            notAfterDate = certificate.getNotAfter();
            days = certificate.getNumOfDays();
            CertMgtPanelUtils.createItemDescriptor(result, 0, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "versionProperty").toString(), version != -1 ? String.valueOf(version) : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString());
            CertMgtPanelUtils.createItemDescriptor(result, 1, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "serialNumberProperty").toString(), serialNumber != null ? serialNumber.toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString());
            CertMgtPanelUtils.createItemDescriptor(result, 2, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "issuerProperty").toString(), issuer != null ? issuer.toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString());
            CertMgtPanelUtils.createItemDescriptor(result, 3, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "validFromProperty").toString(), notBeforeDate != null ? new SimpleDateFormat().format(notBeforeDate) : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString());
            CertMgtPanelUtils.createItemDescriptor(result, 4, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "validUntilProperty").toString(), notAfterDate != null ? new SimpleDateFormat().format(notAfterDate) : (days != null ? days.toString() + " " + new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "fromTimeOfApply").toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString()));
            CertMgtPanelUtils.createItemDescriptor(result, 5, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "subjectProperty").toString(), subject != null ? subject.toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "notAvailable").toString());
            CertMgtPanelUtils.createItemDescriptor(result, 6, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "subjectAltNamesProperty").toString(), subjectAltNames != null ? subjectAltNames.toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "none").toString());
        } else {
            result = new ItemDescriptor[0][0];
        }
        return result;
    }
}

